/*
 * Decompiled with CFR 0.152.
 */
package com.james.tinkerscalibration.modifiers.armor;

import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingEvent;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.modules.technical.ArmorLevelModule;
import slimeknights.tconstruct.library.module.HookProvider;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.capability.TinkerDataCapability;
import slimeknights.tconstruct.library.tools.context.EquipmentContext;
import slimeknights.tconstruct.library.tools.helper.ToolDamageUtil;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;

public class ArmorSolubleModifier
extends Modifier {
    private static final TinkerDataCapability.TinkerDataKey<Integer> SOLUBLE = TConstruct.createKey((String)"soluble_armor");

    public ArmorSolubleModifier() {
        MinecraftForge.EVENT_BUS.addListener(ArmorSolubleModifier::onUpdateApply);
    }

    protected void registerHooks(ModuleHookMap.Builder hookBuilder) {
        hookBuilder.addModule((HookProvider)new ArmorLevelModule(SOLUBLE, false, null));
    }

    private static void onUpdateApply(LivingEvent.LivingTickEvent evt) {
        EquipmentContext context;
        LivingEntity living = evt.getEntity();
        if (!living.m_5833_() && (context = new EquipmentContext(living)).hasModifiableArmor() && !living.f_19853_.f_46443_ && living.m_6084_() && living.f_19797_ % 10 == 0) {
            living.getCapability(TinkerDataCapability.CAPABILITY).ifPresent(holder -> {
                int level = (Integer)holder.get(SOLUBLE, (Object)0);
                if (level > 0) {
                    IToolStackView patt3829$temp;
                    IToolStackView patt3250$temp;
                    IToolStackView patt2670$temp;
                    ToolStack tool;
                    int bonus = ArmorSolubleModifier.getBonus(living);
                    IToolStackView patt2091$temp = context.getToolInSlot(EquipmentSlot.LEGS);
                    if (patt2091$temp instanceof ToolStack) {
                        tool = (ToolStack)patt2091$temp;
                        if (bonus > 0) {
                            ToolDamageUtil.damageAnimated((IToolStackView)tool, (int)bonus, (LivingEntity)living);
                            if (living.m_204029_(FluidTags.f_13131_)) {
                                living.m_20256_(living.m_20154_().m_82542_(0.01, 0.0, 0.01));
                            }
                        }
                    }
                    if ((patt2670$temp = context.getToolInSlot(EquipmentSlot.HEAD)) instanceof ToolStack) {
                        tool = (ToolStack)patt2670$temp;
                        if (bonus > 0) {
                            ToolDamageUtil.damageAnimated((IToolStackView)tool, (int)bonus, (LivingEntity)living);
                            if (living.m_204029_(FluidTags.f_13131_)) {
                                living.m_20256_(living.m_20154_().m_82542_(0.01, 0.0, 0.01));
                            }
                        }
                    }
                    if ((patt3250$temp = context.getToolInSlot(EquipmentSlot.CHEST)) instanceof ToolStack) {
                        tool = (ToolStack)patt3250$temp;
                        if (bonus > 0) {
                            ToolDamageUtil.damageAnimated((IToolStackView)tool, (int)bonus, (LivingEntity)living);
                            if (living.m_204029_(FluidTags.f_13131_)) {
                                living.m_20256_(living.m_20154_().m_82542_(0.01, 0.0, 0.01));
                            }
                        }
                    }
                    if ((patt3829$temp = context.getToolInSlot(EquipmentSlot.FEET)) instanceof ToolStack) {
                        tool = (ToolStack)patt3829$temp;
                        if (bonus > 0) {
                            ToolDamageUtil.damageAnimated((IToolStackView)tool, (int)bonus, (LivingEntity)living);
                            if (living.m_204029_(FluidTags.f_13131_)) {
                                living.m_20256_(living.m_20154_().m_82542_(0.01, 0.0, 0.01));
                            }
                        }
                    }
                }
            });
        }
    }

    private static int getBonus(LivingEntity living) {
        int bonus = 0;
        Level world = living.m_20193_();
        if (living.m_204029_(FluidTags.f_13131_)) {
            bonus = 4;
        } else if (living.m_20193_().m_46758_(living.m_20183_())) {
            bonus = 2;
        }
        return bonus * Math.round(((Biome)world.m_204166_(living.m_20097_()).m_203334_()).m_47554_());
    }
}

